<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/ /** */

require_once APPPATH.'controllers/inbox.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Flag_controller extends Inbox {
	
	/* This function flags a message for review, or removes the flag if it exists already */
	public function save_flag_message(){
		$this->load->model('flag_model');	
		$message_id = $this->input->post('message_uid',TRUE);
		$content = $this->input->post('flag_message_text',TRUE);
		$color = $this->input->post('color-flag',TRUE);
		$id = $this->input->post('flag_id',TRUE);
		
		if(empty($color)){
			$this->flag_model->remove_from_message($message_id); //this will not cause an error if the message is not flagged
		}
		else{
			$values = compact('color', 'content','message_id');
			if($this->flag_model->formatted_like_an_id($id)){
				$flag = $this->flag_model->update_for_message($message_id, $values, $id);
			}
			else {
				$flag = $this->flag_model->set_for_message($message_id, $values);
			}
			if(!empty($flag)) {
				$flag['created_by'] = $this->user_model->user_cn_from_id($flag['created_by']);
				$flag['modified_by'] = $this->user_model->user_cn_from_id($flag['modified_by']);
				echo json_encode($flag);
			}
		}
	}	
	
}
/* End of file inbox.php */
/* Location: ./application/controllers/inbox.php */